#ifndef USBPKTDEFS_H
#define USBPKTDEFS_H

typedef union _BOOT_DATA_PACKET
{
    byte _byte[BOOT_EP_SIZE];  //For Byte Access
    struct
    {
        enum
        {
            READ_VERSION 		   	= 0x00,
            READ_FLASH  		    = 0x01,
            WRITE_FLASH 		    = 0x02,
            ERASE_FLASH 		    = 0x03,
            READ_EEDATA 		    = 0x04,
            WRITE_EEDATA 		   	= 0x05,
            READ_CONFIG  		   	= 0x06,
            WRITE_CONFIG  		 	= 0x07,
            UPDATE_LED   		   	= 0x32,
			WINPIC_GETOKBUTTON 		= 0x50,
			WINPIC_GETDATAINBIT 	= 0x51,
			WINPIC_SETLEDS			= 0x52,
			WINPIC_SETVPP			= 0x53,
			WINPIC_SETVDD			= 0x54,
			WINPIC_SETCLOCKANDDATA	= 0x55,
			WINPIC_SETCLOCKENABLE	= 0x56,
			WINPIC_SETDATAENABLE	= 0x57,
			WINPIC_PULLMCLRTOGND	= 0x58,
			WINPIC_CONNECTTARGET	= 0x59,
			USB_CLOCK_SET_TIME      = 0x70,
			USB_CLOCK_GET_POWER     = 0x71,
			USB_CLOCK_GET_VOLTAGE   = 0x72,
			USB_CLOCK_SET_MODE      = 0x73,
			USB_CLOCK_GET_INFO      = 0x74,
			USB_CLOCK_SET_LV_TRIP   = 0x75,
			USB_CLOCK_SET_PWM       = 0x76,
			USB_CLOCK_SET_TIMEOUT   = 0x77,
    		USB_CLOCK_SET_DEFAULTS  = 0x78,
      		USB_CLOCK_RESET         = 0x79,
			USB_CLOCK_INFO_PACKET	= 0x7A,
			USB_CLOCK_SET_DISPLAY_TIMEOUT   = 0x7B,
            USB_CLOCK_SET_SCROLLING_MODE 	= 0x7C,
            USB_CLOCK_SET_SENSE_RESISTOR    = 0x7D,
            USB_CLOCK_SET_VOLTAGE_REFERENCE = 0x7E,
			USB_CLOCK_SET_AUTO_BACKLIGHT_MODE	=0x7F,
 			USB_CLOCK_SET_TWENTYFOURHOUR_MODE      =0x80,
			USB_CLOCK_SET_NOBATTERY					=0x81,
			RESET                   = 0xFF
        }CMD;
  
	    byte len;
        union
        {
            rom far char *pAdr;             //Address Pointer
            struct
            {
                byte low;                   //Little-indian order
                byte high;
                byte upper;
            };
        }ADR;
        byte data[DATA_SIZE];
    };

	// for UPDATE_LED COMMAND
    struct
    {
        unsigned :8;
        byte led_num;
        byte led_status;
    };

	// for USB_CLOCK_SET_TIME
	struct
	{
		unsigned :8;

        byte 	hours;
		byte	minutes;
		byte 	seconds;
		byte	ydaylow;
		byte	ydayhigh;
		byte    mday;
		byte    wday;
		byte	month;
		byte	yearlow;
		byte	yearhigh;
		byte    isdst;
	};

    // for USB_CLOCK_SET_MODE
    struct
    {
        unsigned :8;

        byte    mode;
    };

 	// for USB_CLOCK_SET_24HOUR_TIME_MODE
    struct
    {
        unsigned   :8;
        byte    settwentyfourhourtime;
    };
    
    // for USB_CLOCK_SET_PWM
    struct
    {
        unsigned :8;
        byte    pwmduty;
    };

	 // for USB_CLOCK_SET_LV_TRIP
    struct
    {
        unsigned :8;

        byte    lvtriplow;
		byte	lvtriphigh;
    }; 

	// for USB_CLOCK_SET_TIMEOUT
    struct
    {
        unsigned    :8;
        byte    timeoutlow;
		byte	timeouthigh;
	};

// for USB_CLOCK_SET_DISPLAY_TIMEOUT
    struct
    {
        unsigned    :8;
        byte    setdisplaytimeouthigh;
        byte    setdisplaytimeoutlow;
    };
    
    // for USB_CLOCK_SET_SCROLLING_MODE
    struct
    {
        unsigned    :8;
        byte	setscrollingmode;
    };
    
    // for USB_CLOCK_SET_SENSE_RESISTOR
    struct
    {
        unsigned    :8;
        byte       setsenseresistorhigh;
        byte       setsenseresistorlow;
    };
    
    // for USB_CLOCK_SET_VOLTAGE_REFERENCE
    struct
    {
        unsigned    :8;
        byte        setvoltagerefhigh;
        byte        setvoltagereflow;
    };

	// for USB_CLOCK_SET_AUTO_BACKLIGHT_MODE
	struct
	{
		unsigned	:8;
		byte		tosetautobacklightmode;
	};

    // for USB_CLOCK_SET_NOBATTERY
    struct
    {
        unsigned :8;
        byte    setnobattery;
    };

	// for USB_CLOCK_INFO_PACKET back to PC
	struct
	{
		unsigned :8;
		byte 	usbhours;
		byte	usbminutes;
		byte 	usbseconds;
		byte	usbydaylow;
		byte	usbydayhigh;
		byte	usbmday;
		byte	usbwday;
		byte	usbisdst;
		byte	usbmonth;
		byte	usbyearlow;
		byte	usbyearhigh;
		byte	usbmode;
		byte	an0low;
		byte	an0high;
		byte 	an1low;
		byte	an1high;
		byte	verlow;
		byte	verhigh;
		byte	usbpwmduty;
		byte	usbtimeoutlow;
		byte	usbtimeouthigh;
		byte	usblvtriplow;
		byte	usblvtriphigh;
		byte    actualtriplow;
        byte    actualtriphigh;
    	byte	lasthours;
		byte	lastminutes;
		byte	lastseconds;
		byte	lastydaylow;
		byte	lastydayhigh;
		byte 	lastwday;
		byte 	lastmday;
		byte	lastisdst;
		byte	lastmonth;
		byte	lastyearlow;
		byte	lastyearhigh;
		byte    currentPWMDuty;
		byte	usbregassumedvoltagelow;
		byte	usbregassumedvoltagehigh;
		byte	powermode;
		byte	senseresistorlow;
		byte	senseresistorhigh;
		byte	scrollingmode;
		byte	displaytimeoutlow;
		byte	displaytimeouthigh;
		byte	setautobacklightmode;
		byte    twentyfourhourtime;
		byte	nobatterymode;
		byte	rtchigh;
		byte	rtclow;
		byte	displaycounthigh;
		byte	displaycountlow;
		byte	usbsyncNeeded;
	};

} BOOT_DATA_PACKET;

#endif
